<?php

/**
 * Uninstall script for StatusPage Widget.
 *
 * Fired when the plugin is uninstalled.
 *
 * @package StatusPageWidget
 */

// Exit if not called by WordPress.
if (! defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete all transients created by the plugin.
global $wpdb;
$wpdb->query(
    "DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_statuspage_%' OR option_name LIKE '_transient_timeout_statuspage_%'"
);

// Delete any plugin options if they exist.
delete_option('statuspage_widget_settings');
delete_option('statuspage_widget_version');

// Clean up any widget options.
delete_option('widget_statuspage_widget');
